/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import org.betterx.bclib.blocks.BaseAnvilBlock;
import org.betterx.bclib.blocks.LeveledAnvilBlock;
import org.betterx.bclib.interfaces.AnvilScreenHandlerExtended;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1706.class})
public abstract class AnvilMenuMixin
extends class_4861
implements AnvilScreenHandlerExtended {
    private List<AnvilRecipe> be_recipes = Collections.emptyList();
    private AnvilRecipe be_currentRecipe;
    private class_3915 anvilLevel;
    @Shadow
    private int field_7776;
    @Final
    @Shadow
    private class_3915 field_7770;

    public AnvilMenuMixin(@Nullable class_3917<?> menuType, int i, class_1661 inventory, class_3914 containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="TAIL")})
    public void be_initAnvilLevel(int syncId, class_1661 inventory, class_3914 context, CallbackInfo info) {
        this.anvilLevel = this.method_17362(class_3915.method_17403());
        if (context != class_3914.field_17304) {
            int level = (Integer)context.method_17396((world, blockPos) -> {
                class_2248 anvilBlock = world.method_8320(blockPos).method_26204();
                return LeveledAnvilBlock.getAnvilCraftingLevel(anvilBlock);
            }, (Object)0);
            this.anvilLevel.method_17404(level);
        } else {
            this.anvilLevel.method_17404(0);
        }
    }

    @Shadow
    public abstract void method_24928();

    @Inject(method={"mayPickup"}, at={@At(value="HEAD")}, cancellable=true)
    protected void be_canTakeOutput(class_1657 player, boolean present, CallbackInfoReturnable<Boolean> info) {
        if (this.be_currentRecipe != null) {
            info.setReturnValue((Object)this.be_currentRecipe.checkHammerDurability(this.field_22480, player));
        }
    }

    @Inject(method={"method_24922"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bclib_onDamageAnvil(class_1657 player, class_1937 level, class_2338 blockPos, CallbackInfo ci) {
        class_2680 blockState = level.method_8320(blockPos);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof BaseAnvilBlock) {
            BaseAnvilBlock anvil = (BaseAnvilBlock)class_22482;
            class_2680 damaged = anvil.damageAnvilUse(blockState, player.method_6051());
            AnvilMenuMixin.bcl_destroyWhenNull(level, blockPos, damaged);
            ci.cancel();
        }
    }

    private static void bcl_destroyWhenNull(class_1937 level, class_2338 blockPos, class_2680 damaged) {
        if (damaged == null) {
            level.method_8650(blockPos, false);
            level.method_20290(1029, blockPos, 0);
        } else {
            level.method_8652(blockPos, damaged, 2);
            level.method_20290(1030, blockPos, 0);
        }
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
    protected void bclib_onTakeAnvilOutput(class_1657 player, class_1799 stack, CallbackInfo info) {
        if (this.be_currentRecipe != null) {
            int ingredientSlot = AnvilRecipe.getIngredientSlot(this.field_22480);
            this.field_22480.method_5438(ingredientSlot).method_7934(this.be_currentRecipe.getInputCount());
            stack = this.be_currentRecipe.craft(this.field_22480, player);
            this.method_7609(this.field_22480);
            this.field_22481.method_17393((level, blockPos) -> {
                class_2680 anvilState = level.method_8320(blockPos);
                class_2248 anvilBlock = anvilState.method_26204();
                if (anvilBlock instanceof BaseAnvilBlock) {
                    BaseAnvilBlock anvil = (BaseAnvilBlock)anvilBlock;
                    if (!player.method_31549().field_7477 && anvilState.method_26164(class_3481.field_15486) && player.method_6051().method_43058() < 0.1) {
                        class_2680 damagedState = anvil.damageAnvilUse(anvilState, player.method_6051());
                        AnvilMenuMixin.bcl_destroyWhenNull(level, blockPos, damagedState);
                    } else {
                        level.method_20290(1030, blockPos, 0);
                    }
                }
            });
            info.cancel();
        }
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void be_updateOutput(CallbackInfo info) {
        class_1863 recipeManager = this.field_22482.field_6002.method_8433();
        this.be_recipes = recipeManager.method_17877(AnvilRecipe.TYPE, this.field_22480, this.field_22482.field_6002);
        if (this.be_recipes.size() > 0) {
            int anvilLevel = this.anvilLevel.method_17407();
            this.be_recipes = this.be_recipes.stream().filter(recipe -> anvilLevel >= recipe.getAnvilLevel()).collect(Collectors.toList());
            if (this.be_recipes.size() > 0) {
                if (this.be_currentRecipe == null || !this.be_recipes.contains(this.be_currentRecipe)) {
                    this.be_currentRecipe = this.be_recipes.get(0);
                }
                this.be_updateResult();
                info.cancel();
            } else {
                this.be_currentRecipe = null;
            }
        }
    }

    @Inject(method={"setItemName"}, at={@At(value="HEAD")}, cancellable=true)
    public void be_setNewItemName(String string, CallbackInfo info) {
        if (this.be_currentRecipe != null) {
            info.cancel();
        }
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0) {
            this.be_previousRecipe();
            return true;
        }
        if (id == 1) {
            this.be_nextRecipe();
            return true;
        }
        return super.method_7604(player, id);
    }

    private void be_updateResult() {
        if (this.be_currentRecipe == null) {
            return;
        }
        this.field_22479.method_5447(0, this.be_currentRecipe.method_8116(this.field_22480));
        this.method_7623();
    }

    @Override
    public void be_updateCurrentRecipe(AnvilRecipe recipe) {
        this.be_currentRecipe = recipe;
        this.be_updateResult();
    }

    @Override
    public AnvilRecipe be_getCurrentRecipe() {
        return this.be_currentRecipe;
    }

    @Override
    public List<AnvilRecipe> be_getRecipes() {
        return this.be_recipes;
    }
}

